﻿//////////////////////////////////////////////
// ConsoleOutputFormatter.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestClassObserverInformation ;
	class TestFunctionObserverInformation ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

#include "OutputFormatter.h"

// 

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT ConsoleOutputFormatter final : public OutputFormatter
	{
		public :

			// Constructor, destructor
			ConsoleOutputFormatter () noexcept ;
			virtual ~ConsoleOutputFormatter () ;

			// Formatting
			virtual nkMemory::String formatRunLaunch (const TestRunParameters& params) override ;
			virtual nkMemory::String formatRunEnd () override ;
			virtual nkMemory::String formatClassLaunch (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatClassBypass (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatClassEnd (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatTestLaunch (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestBypass (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestSuccess (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestFailure (const TestFunctionObserverInformation& info) override ;

		private :

			// Attributes
			nkMemory::String* _failedTests ;
			unsigned long long _totalMicroS ;

			unsigned int _totalClassRuns ;
			unsigned int _totalClassBypass ;
			unsigned int _totalFunctionRuns ;
			unsigned int _totalFunctionSuccess ;
			unsigned int _totalFunctionBypass ;
			unsigned int _totalFunctionFailed ;
	} ;
}